#version 130
#extension GL_EXT_gpu_shader4 : enable
/////////////////////////////////////////////////////////////
// VGHD Wrapper for Shadertoy conversions by @Calgon


uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*1
#define iResolution u_WindowSize
//#define iGlobalTime u_Elapsed
#define iGlobalTime u_Elapsed


// Seems the word texture is important and should not be replaced.  Therefore we must replace
// Shadertoy iChannel0..3 with texture 0..3 further down
uniform sampler2D texture0; //Font
uniform sampler2D texture1; //Surfaces
uniform sampler2D texture2; //SurfacesB
uniform sampler2D texture3; //Random Greys

//vec4 texture1D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
//vec4 texture1D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}
vec4 texture1D_Fract(sampler2D sampler,vec2 P) {return texture(sampler,fract(P));}
vec4 texture1D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture(sampler,fract(P),Bias);}

// Calgon Amemned texture1D to texture - wait and see if this will be an issue during conversions

//#define texture1D texture1D_Fract
#define texture texture1D_Fract



vec4 vTexCoord = gl_TexCoord[0];


//#define iMouse vec4(0.0)

// Alternative Macro if iMouse is better moving
 #define iMouse AUTO_MOUSE  //vec4(0.0,0.0,0.0,0.0)

// Simple "Automatic Mouse". Simulates scanning the mouse over the full range of
// the screen with the X and Y scanning frequencies being different. TheEmu.

#define MOUSE_SPEED vec2(0.5,0.577777) * 0.2
#define MOUSE_POS vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
#define MOUSE_PRESS vec2(1.0,1.0)
#define AUTO_MOUSE vec4( MOUSE_POS, MOUSE_PRESS )



int texture_size = 512;


// Scene Input variables
uniform float cycle_time; 	// Duration of the full cycle
uniform float alpha_on; 	// Time in cycle to switch on alpha channel
uniform float alpha_off; 	// Switch off alpha
uniform float alpha_always_on; 	// Switch off alpha
uniform float scene_length; 	// Switch off alpha

uniform float scene_duration; 
uniform float maxbgnum;	

vec4 col;
//////////////////////////////////////////////////////////////
// Calgon - Random number

// Extract a pixel from texture1 to get the random number
//float randNum = texture(texture0, vec2(1/10., 1/10.)).r;
//float randNum = texture(texture3, vec2(1/1024., 1/1024.)).a;
float randNum = texture(texture3, vec2(0.,0.)).a;





//float text_line = 3/texture_size;
//float place = 10./texture_size;
//float myCharacter = texture(texture1, vec2(place, text_line)).a;
//int myInt = int(myCharacter*255);

float text_line;
float place;
float myCharacter;
int myInt;



// Extract game data
int game_texture_size = 10;






///////////////////////////////////////////////////////////////////////////////////////////////////
// Shadertoy Code follows
// Replace Shadertoy iChannel0..3 with texture0..3
///////////////////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////
//
// "fontastic" 
//
// small font utility package
//
// by Val "valalalalala" GvM - 2020
// Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License
//
// super useful: https://www.shadertoy.com/view/ldSBzd
// ascii table https://theasciicode.com.ar/
// https://shadertoyunofficial.wordpress.com/2016/07/20/special-shadertoy-features/
//
/////////////////////////////////////////////////////////////////////////////

#define FONT_DEMO

//#define FONT_SAMPLER    texture0
#define FONT_SAMPLER    texture3


#define FONT_STRIDE(n)  ((n)*vec2( .5, .0 ))

#define FONT_STAR 28
#define FONT_0    48
#define FONT_DASH 45
#define FONT_DOT  46
#define FONT_T    84
#define FONT_e    101
#define FONT_s    115
#define FONT_t    116

float characterDistance( vec2 point, int character ) {
    vec2 charAt = vec2( character % 16, 15 - character / 16 ) / 16. + 1./32.;    
    float w = textureLod( FONT_SAMPLER, charAt + point / 16., .0 ).w;
    vec2 box = abs( point / .8 );
    return max( w, max( box.x, box.y ) );
}

float characterLength( int value ) {
    return floor( 1. + log2( float( abs( ( value == 0 ) ? 1 : value ) ) ) / log2( 10.) );
}

float numericStringDistance( vec2 point, int value ) {
    point -= FONT_STRIDE( characterLength( value ) - 1. );
    float d = 0 == value ? characterDistance( point, FONT_0 ) : 1e33;  
    for( int v = abs( value ) ; 0 != v ; v /= 10, point += FONT_STRIDE( 1. ) ) {
        d = min( d, characterDistance( point, FONT_0 + v % 10 ) );
    }  
    return min( d, value < 0 ? characterDistance( point, FONT_DASH ) : 1e33 );
}

float numericStringDistance( in vec2 point, in float value, int decimals ) {
    int vi = int( sign( value ) * floor( abs( value ) ) );
    float d = numericStringDistance( point, vi );  
    
    point -= FONT_STRIDE( characterLength( vi ) );
  //  d = min( d, characterDistance( point, FONT_DOT ) );

    point -= FONT_STRIDE(1.);
    
    float vf = fract( abs( value ) ) * 10.;
    int max = int( pow( 10., float( decimals ) ) );
    for ( int i = 1 ; i <= decimals ; i++, vf *=10. , point -= FONT_STRIDE( 1. ) ) {
        int n = int( vf ) % 10;
        d = min( d, characterDistance( point, FONT_0 + n % 10 ) );
    }

    return d;
}

float numericStringDistance( in vec2 point, in float value ) {
//	return numericStringDistance( point, value, 2 );
    return numericStringDistance( point, value, 0 );
}

float stringDistance( vec2 point, int string ) {
    return 
        min( characterDistance( point, ( string >> 0 ) & 0xFF ),
        min( characterDistance( point - FONT_STRIDE( 1. ), ( string >> 8 ) & 0xFF ),
        min( characterDistance( point - FONT_STRIDE( 2. ), ( string >> 16 ) & 0xFF ),
             characterDistance( point - FONT_STRIDE( 3. ), ( string >> 24 ) & 0xFF ))));
}

float stringDistance( vec2 point, ivec4 string ) {
    return
        min( stringDistance( point - FONT_STRIDE( 0. * 4. ), string[ 0 ] ),
        min( stringDistance( point - FONT_STRIDE( 1. * 4. ), string[ 1 ] ),
        min( stringDistance( point - FONT_STRIDE( 2. * 4. ), string[ 2 ] ),
             stringDistance( point - FONT_STRIDE( 3. * 4. ), string[ 3 ]))));
}

#ifdef FONT_DEMO

#define NUMERIC    numericStringDistance
#define STRING     stringDistance
#define CHARACTER  characterDistance

float distanceToShape( float d, float t ) {
    return smoothstep( .5 - t, .5 + t, 1.-d );
}

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
    vec2 uv = ( 2. * fragCoord - iResolution.xy ) / iResolution.y;
    
    float d = 1e33;
    
    int character = int( mod( iTime, 256. ) );
    vec2 trig = vec2( cos( iTime ), sin( iTime ) );
	vec2 gD = vec2 (0.0);
	gD.x = 1.5/10.;
	gD.y = 1.5/10.;
	
 
	float game1 = texture(texture3, vec2(gD.x,gD.y)).r;
	game1 *= 100;
 
 // Game Data
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .6 ) ) / .07, game1 ) );
 
	
	float pathway = int(randNum * 100);
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .87 ) ) / .07, pathway ) );
	
	
	
	float next_girl = scene_length - (scene_length*fract(u_Elapsed/scene_length));
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .63 ) ) / .07, next_girl ) );
	
	
	
	
	
	float score = int(u_Elapsed/1.)*10.;
	//if (score > 100.){
			

	//}
	
	// Add the scene number
	
	float my_cycle_time = maxbgnum * scene_duration;
	float my_part_cycle = my_cycle_time * fract(u_Elapsed / my_cycle_time);
	
	
	
	
	
	float scene_num = int((my_part_cycle ) / scene_duration) + 1. ;
	//scene_num = my_part_cycle;
	
	
	
	
	
//	d = min( d, NUMERIC( ( uv - vec2( -1.46, .95 ) ) / .07, scene_num ) );
	d = min( d, NUMERIC( ( uv - vec2( -1.56, .95 ) ) / .07, scene_num ) );
	
	
	
	
	
	
//	d = min( d, CHARACTER( ( uv - vec2( 1.0, .8 ) ) / .13, 64 ) );	// Print an @ symbol
	
	float chars_per_line = 30.;
	
	
	
	
	///////// Work out which texture to read
	float bump_time = 0.;
	if (alpha_always_on == 1.){
		bump_time = 1.;
	
	}
	float cycles = (u_Elapsed + bump_time)/cycle_time;
	float full_cycles = trunc(cycles);
    float part_cycles = u_Elapsed - (full_cycles * cycle_time);
	
	float part_even_cycles = fract(full_cycles/2.);
	float even_cycles = 0.;
	if (part_even_cycles > 0.1){
		even_cycles = 1.;
	}
	
	
	
	
	
	
	
	
	
	
	
	
	// Get the length of the message - Add .5 to the distances
	place = (0+.5)/texture_size;
	text_line =  (0.+.5)/texture_size;
	
	if (even_cycles == 0.){
		myCharacter = texture(texture1, vec2(place, text_line)).a;
	}
	else{
		myCharacter = texture(texture2, vec2(place, text_line)).a;
	}
	
	
	//myCharacter = texture(texture1, vec2(place, text_line)).a;
	float msgLen = int(round(myCharacter*255));
	
	for (float x=0; x<=msgLen-1; x++){
		//place = x/512.+.0001;
		place = (.5+x)/texture_size;
		
		text_line =  (1.+.5)/texture_size;
		
		if (even_cycles == 0.){
			myCharacter = texture(texture1, vec2(place, text_line)).a;
		}
		else{
			myCharacter = texture(texture2, vec2(place, text_line)).a;
		}
			
			
			
			
		myInt = int(round(myCharacter*255));
		float x_pos = x/27.-1.75;
		float y_offset = int(x/chars_per_line);
		float y_pos = -y_offset*.1 + .71;
		float adj_x_pos = x_pos - (y_offset)*.1*(chars_per_line);
		//adj_x_pos = x_pos;
		
	//	d = min( d, CHARACTER( ( uv - vec2( adj_x_pos, y_pos ) ) / .07, myInt ) );
		

		
		
		
	}
	
    
	// Notes.... look into how this works further...
	
    // pack 4 characters into an int 
    int test = FONT_T << 0 | FONT_e << 8 | FONT_s << 16 | FONT_t << 24;
 //   d = min( d, STRING(  ( uv - vec2( 1.2, -.4 ) ) / .1, test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.5 ) ) / .1, test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.6 ) ) / .1, -1*test ) );
 //   d = min( d, NUMERIC( ( uv - vec2( 1.2, -.7 ) ) / .1, 0*test ) );
	
	
	
	float line_x = 1;
	float line_y = 1;
	
	for (float line_x = 1; line_x <= 30; line_x++)
	{	
		text_line =  4/texture_size;
		float write_x = line_x/20.-0.;
		float letter_img_x = line_x/texture_size;
		
		float myLetter = texture(texture1, vec2(letter_img_x, text_line)).a;
		int myInt = int(myCharacter*255);

		
		
		
		//d = min( d, CHARACTER( ( uv - vec2( write_x, -1. ) ) / .1, myInt ) );
	}
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	

    // https://luckybit4755.github.io/shady-lady/html/text-to-ivec4.html
 //   ivec4 text1 = ivec4( 543516756, 1667855729, 1919033451, 544110447 ); /* "The quick brown " */
 //   ivec4 text2 = ivec4( 544763750, 1886221674, 1986994291, 538997349 ); /* "fox jumps over  " */
  //  ivec4 text3 = ivec4( 543516788, 2038063468, 1735353376, 538976288 ); /* "the lazy dog    " */

	
	ivec4 text1 = ivec4( 1953720644, 1952672114, 538976314, 538976288 ); /* "District:       " */
	ivec4 text2 = ivec4( 1752457552, 981033335, 538976288, 538976288 ); /* "Pathway:        " */
//	ivec4 text3 = ivec4( 1919902547, 538983013, 538976288, 538976288 ); /* "Score:          " */	
	ivec4 text4 = ivec4( 1954047310, 1819692064, 538976314, 538976288 ); /* "Next Lvl:       " */
	
	ivec4 text3 = ivec4( 1852138323, 538983013, 538976288, 538976288 ); /* "Scene:          " */
	
 //   d = min( d, STRING( ( uv - vec2( -1.75, .79 ) ) / .06, text1 ) );
 //   d = min( d, STRING( ( uv - vec2( -1.75, .87 ) ) / .06, text2 ) );
    d = min( d, STRING( ( uv - vec2( -1.75, .95 ) ) / .06, text3 ) );
//	d = min( d, STRING( ( uv - vec2( -1.75, .63 ) ) / .06, text4 ) );
    




  //  d = min( d, CHARACTER( ( uv - vec2( trig.x * 1.33, -.88 ) ) / .22, FONT_STAR ) );

    ////
    
    float r = distanceToShape( d, .00001 );
    float c = distanceToShape( d, .001 );
	
	vec4 finalCol = vec4( vec3( r * 5., c*5., c *.6 ), 1. );
	float grey = (finalCol.r + finalCol.g +finalCol.b);
	finalCol.a = smoothstep(0.,0.01,grey);
	//finalCol.r = 0.;
	finalCol.a *= 0.7;
	
	if (part_cycles < alpha_on){
		finalCol.a = 0.0;
	}
	if (part_cycles > alpha_off){
		finalCol.a = 0.0;
	}
	
	vec4 endResult = vec4( vec3( r * 5., c*5., c *.6 ), finalCol.a );
	endResult.rgb = vec3(1.);
	endResult.rb = vec2(.7);
	//endResult.a = endResult.g;
	
    //fragColor = vec4( vec3( r * 5., c*5., c *.6 ), finalCol.a );
	fragColor = endResult;
}

#endif
///////////////////////////////////////////////////////////////////////
void main ( void )
{




   mainImage ( gl_FragColor, gl_FragCoord.xy );
   //  gl_FragColor.a = 0.0;
  
  
   
   
   
   
   // gl_FragColor.a = 1.0;
}












